<?php

if(!defined('IN_GS')){ die('You cannot load this page directly.'); }

Error_Reporting(0); // E_ALL & ~E_NOTICE

/*
Plugin Name: My Gallery (my-gallery.php)
Description: Gallery plugin with the ability to upload images through the admin panel
Version: 1.0.4 / nov 2020
Author: NetExplorer
Email: netexplorer@yandex.ru
Author URI: http://netexplorer.h1n.ru

This plugin will help you create a gallery.
How to install a gallery?

Unzip and place file in the plugin folder of GetSimple. Then activate the plugin My Gallery (my-gallery.php).

Create a gallery, select it and upload files. You can create multiple galleries. 
For output, use a short-code or PHP-code that is automatically generated for each new gallery.

The plugin can be translated into other languages. See /lang/en.php, ru.php ... 
Make your translation and upload the "xx.php" file to the directory - /lang/ - then select your language file in the plugin settings.
When uploading large files сheck the values upload_max_filesize and post_max_size in php.ini.

Also see LICENSE.txt, README.txt
*/

// Get correct id for plugin
$my_gallery_thisfile = basename(__FILE__, '.php');

// Load configuration
require(GSROOTPATH.'plugins/'.$my_gallery_thisfile.'/cfg.php');

// Load language
require(GSROOTPATH.'plugins/'.$my_gallery_thisfile.'/lang/'.$my_gallery_language.'.php');

// Register plugin
register_plugin(
    $my_gallery_thisfile,    // ID of plugin, should be filename minus php
    $my_gallery_plugin_name,    // Title of plugin
    '1.0.4',    // Version of plugin
    'NetExplorer',    // Author of plugin
    'http://netexplorer.h1n.ru',    // Author URL
    $my_gallery_small_description,    // Plugin Description
    'plugins',    // Page type of plugin
    'my_gallery_options'    // Function that displays content
);

// Load plugin CSS correction for GS >= 3.4
if (@$_GET['id'] == 'my-gallery' && round(GSVERSION, 2) >= '3.4') { 
register_style('my_gallery_admin_style_correction', $SITEURL.'plugins/'.$my_gallery_thisfile.'/admin_correction.css', false, 'all');
queue_style('my_gallery_admin_style_correction', GSBACK);
}

// MyGallery JS
register_script('my_gallery_js_mygallery', $SITEURL.'plugins/'.$my_gallery_thisfile.'/functions.js', false, false);
queue_script('my_gallery_js_mygallery', GSFRONT);

// BaguetteBox CSS
register_style('my_gallery_style_baguettebox', $SITEURL.'plugins/'.$my_gallery_thisfile.'/baguettebox/baguettebox.css', false, 'all');
queue_style('my_gallery_style_baguettebox', GSFRONT);
// BaguetteBox JS
register_script('my_gallery_js_baguettebox', $SITEURL.'plugins/'.$my_gallery_thisfile.'/baguettebox/baguettebox.js', false, false);
queue_script('my_gallery_js_baguettebox', GSFRONT);

// PhotoSwipe CSS
register_style('my_gallery_style_photoswipe', $SITEURL.'plugins/'.$my_gallery_thisfile.'/photoswipe/photoswipe.css', false, 'all');
queue_style('my_gallery_style_photoswipe', GSFRONT);
register_style('my_gallery_style_photoswipe_skin', $SITEURL.'plugins/'.$my_gallery_thisfile.'/photoswipe/default-skin/default-skin.css', false, 'all');
queue_style('my_gallery_style_photoswipe_skin', GSFRONT);

// PhotoSwipe JS
register_script('my_gallery_js_photoswipe', $SITEURL.'plugins/'.$my_gallery_thisfile.'/photoswipe/photoswipe.min.js', false, false);
queue_script('my_gallery_js_photoswipe', GSFRONT);
register_script('my_gallery_js_photoswipe_ui', $SITEURL.'plugins/'.$my_gallery_thisfile.'/photoswipe/photoswipe-ui-default.min.js', false, false);
queue_script('my_gallery_js_photoswipe_ui', GSFRONT);
register_script('my_gallery_js_photoswipe_unit', $SITEURL.'plugins/'.$my_gallery_thisfile.'/photoswipe/photoswipe-init.js', false, false);
queue_script('my_gallery_js_photoswipe_unit', GSFRONT);

// Swiper CSS
register_style('my_gallery_style_swiper', $SITEURL.'plugins/'.$my_gallery_thisfile.'/swiper/swiper-bundle.css', false, 'all');
queue_style('my_gallery_style_swiper', GSFRONT);

// Swiper JS
register_script('my_gallery_js_swiper', $SITEURL.'plugins/'.$my_gallery_thisfile.'/swiper/swiper-bundle.min.js', false, false);
queue_script('my_gallery_js_swiper', GSFRONT);

// Creates a menu option on the Admin/Theme sidebar
add_action('plugins-sidebar', 'createSideMenu', array($my_gallery_thisfile, $my_gallery_plugin_name));

// activate filter
add_filter('content', 'ShortCodeGetMyGallery');

// Show options in plugin page
function my_gallery_options() {
	global $my_gallery_thisfile, $my_gallery_language;
	
	// Load language
	require(GSROOTPATH.'plugins/'.$my_gallery_thisfile.'/lang/'.$my_gallery_language.'.php');
	
	// Please do not remove the donation links. If you want remove - please donate $2 for every domain.
	echo $my_gallery_description . '
<form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_blank" style="display: inline;">
<input type="hidden" name="cmd" value="_donations">
<input type="hidden" name="business" value="netexplorer@yandex.ru">
<input type="hidden" name="currency_code" value="USD">
<input type="submit" border="0" name="submit" class="button" value="'.$my_gallery_admin_donate.'" title="Donate with PayPal button" alt="Donate with PayPal button">
</form> &nbsp; <a href="https://money.yandex.ru/to/410012986152433" target="_blank">Yandex.Money</a>
';

	// Load plugin settings
	require(GSROOTPATH.'plugins/'.$my_gallery_thisfile.'/admin.php');
}



//*** Get My Gallery ***//
function GetMyGallery($my_gallery_dir = 'no-galleries') {
   global $my_gallery_thisfile, $my_gallery_msg_no_files, $SITEURL; 
   require(GSROOTPATH.'plugins/'.$my_gallery_thisfile.'/cfg.php');
   
   // Always check this file for existence
   $my_gallery_dir_cfgfile = GSROOTPATH.'plugins/'.$my_gallery_thisfile.'/galleries/cfg/'.$my_gallery_dir.'.php'; 
   if (file_exists($my_gallery_dir_cfgfile)) { 
   require($my_gallery_dir_cfgfile);
   }
   else { 
   // By default
   $my_gallery_output_script = 'BaguetteBox'; 
   $my_gallery_default_thumbnails_size = '240'; 
   $my_gallery_default_images_size = '1024';
   $my_gallery_default_slides_per_view = '1';
   $my_gallery_default_slides_autoplay = 'checked';
   } 

if ($my_gallery_output_script == 'BaguetteBox'):
$return = '';
$return .= '
<div class="baguetteBoxOne baguetteBox_gallery baguetteBox_'.$my_gallery_thisfile.'_'.$my_gallery_dir.'">';
        if (file_exists(GSROOTPATH.'plugins/'.$my_gallery_thisfile.'/galleries/'.$my_gallery_dir.'/cache_gallery.dat')) {
			$arr = file(GSROOTPATH.'plugins/'.$my_gallery_thisfile.'/galleries/'.$my_gallery_dir.'/cache_gallery.dat', FILE_IGNORE_NEW_LINES);
			$nom = count($arr);
			if ($nom) {
				for($i = 0; $i < $nom; ++$i) {		
					$thumbnails = getimagesize(GSROOTPATH.'plugins/'.$my_gallery_thisfile.'/galleries/'.$my_gallery_dir.'/s_'.$arr[$i]);				
					$title = file_get_contents(GSROOTPATH.'plugins/'.$my_gallery_thisfile.'/galleries/'.$my_gallery_dir.'/title_'.$arr[$i].'_dat');
					if (strip_tags($title) == $title) { $data_type = 'img'; } else { $data_type = 'html'; }
					if ($data_type == 'img') { $test_link = substr($title, 0, 4); } else { $test_link = ''; }
					$return .= '<a '.($test_link == 'http' ? 'class="link_blank" onclick="window.open(\''.$title.'\', \'_blank\'); this.setAttribute(\'href\', \'javascript:void(0);\');"' : '').' href="'.$SITEURL.'plugins/'.$my_gallery_thisfile.'/galleries/'.$my_gallery_dir.'/'.$arr[$i].'" title="'.($data_type == 'img' && $test_link != 'http' ? $title : '').'" data-type="'.$data_type.'" data-iframe-video="'.(substr($title, 0,7) == '<iframe' && $data_type == 'html' ? 'yes' : '').'" data-html-content="'.($data_type == 'html' ? base64_encode($title) : '').'"><img src="'.$SITEURL.'plugins/'.$my_gallery_thisfile.'/galleries/'.$my_gallery_dir.'/s_'.$arr[$i].'" alt="'.($data_type == 'img' && $test_link != 'http' ? $title : '').'" '.($thumbnails[0] != $my_gallery_default_thumbnails_size ? 'style="width: '.$my_gallery_default_thumbnails_size.'px;"' : '').'></a>';
				}
			}
			else {
			  $return .= $my_gallery_msg_no_files;
			}
		} else {
			$return .= $my_gallery_msg_no_files;
		}	
$return .= '
</div>
<script>
	baguetteBox.run(".baguetteBox_'.$my_gallery_thisfile.'_'.$my_gallery_dir.'", {
		onChange: function(currentIndex, imagesCount) { MyGallery_stopVideo(".full-image iframe"); },
		afterHide: function() { MyGallery_stopVideo(".full-image iframe"); },
		ignoreClass: "link_blank",
	});
</script>';
endif;

if ($my_gallery_output_script == 'PhotoSwipe'):
$return = '';
$return .= '
<div class="PhotoSwipe_gallery PhotoSwipe_'.$my_gallery_thisfile.'_'.$my_gallery_dir.'" itemscope itemtype>';
        if (file_exists(GSROOTPATH.'plugins/'.$my_gallery_thisfile.'/galleries/'.$my_gallery_dir.'/cache_gallery.dat')) {
			$arr = file(GSROOTPATH.'plugins/'.$my_gallery_thisfile.'/galleries/'.$my_gallery_dir.'/cache_gallery.dat', FILE_IGNORE_NEW_LINES);
			$nom = count($arr);
			if ($nom) {
				for($i = 0; $i < $nom; ++$i) {	
					$imagesize = getimagesize(GSROOTPATH.'plugins/'.$my_gallery_thisfile.'/galleries/'.$my_gallery_dir.'/'.$arr[$i]);
					$thumbnails = getimagesize(GSROOTPATH.'plugins/'.$my_gallery_thisfile.'/galleries/'.$my_gallery_dir.'/s_'.$arr[$i]);
					$title = file_get_contents(GSROOTPATH.'plugins/'.$my_gallery_thisfile.'/galleries/'.$my_gallery_dir.'/title_'.$arr[$i].'_dat');
					if (strip_tags($title) == $title) { $data_type = 'img'; } else { $data_type = 'html'; }
					if ($data_type == 'img') { $test_link = substr($title, 0, 4); } else { $test_link = ''; }
					$return .= '
					'.($test_link == 'http' ? '<div' : '<figure').' itemprop="associatedMedia" itemscope itemtype>
						<a '.($test_link == 'http' ? 'onclick="window.open(\''.$title.'\', \'_blank\');"' : '').' href="'.$SITEURL.'plugins/'.$my_gallery_thisfile.'/galleries/'.$my_gallery_dir.'/'.$arr[$i].'" title="'.($data_type == 'img' && $test_link != 'http' ? $title : '').'" itemprop="contentUrl" data-size="'.$imagesize[0].'x'.$imagesize[1].'" data-type="'.$data_type.'" data-iframe-video="'.(substr($title, 0,7) == '<iframe' && $data_type == 'html' ? 'yes' : '').'" data-html-content="'.($data_type == 'html' ? base64_encode($title) : '').'">
							<img src="'.$SITEURL.'plugins/'.$my_gallery_thisfile.'/galleries/'.$my_gallery_dir.'/s_'.$arr[$i].'" alt="'.($data_type == 'img' && $test_link != 'http' ? $title : '').'" '.($thumbnails[0] != $my_gallery_default_thumbnails_size ? 'style="width: '.$my_gallery_default_thumbnails_size.'px;"' : '').'>
						</a>
						<figcaption itemprop="caption description">'.($data_type == 'img' && $test_link != 'http' ? $title : '').'</figcaption>
					'.($test_link == 'http' ? '</div>' : '</figure>').'';
				}
			}
			else {
			  $return .= $my_gallery_msg_no_files;
			}
		} else {
			$return .= $my_gallery_msg_no_files;
		}	
$return .= '
</div>
<!-- Root element of PhotoSwipe. Must have class pswp. -->
<div class="pswp" tabindex="-1" role="dialog" aria-hidden="true">

    <!-- Background of PhotoSwipe. 
         Its a separate element as animating opacity is faster than rgba(). -->
    <div class="pswp__bg"></div>

    <!-- Slides wrapper with overflow:hidden. -->
    <div class="pswp__scroll-wrap">

        <!-- Container that holds slides. 
            PhotoSwipe keeps only 3 of them in the DOM to save memory.
            Dont modify these 3 pswp__item elements, data is added later on. -->
        <div class="pswp__container">
            <div class="pswp__item"></div>
            <div class="pswp__item"></div>
            <div class="pswp__item"></div>
        </div>

        <!-- Default (PhotoSwipeUI_Default) interface on top of sliding area. Can be changed. -->
        <div class="pswp__ui pswp__ui--hidden">

            <div class="pswp__top-bar">

                <!--  Controls are self-explanatory. Order can be changed. -->

                <div class="pswp__counter"></div>

                <button class="pswp__button pswp__button--close" title="Close (Esc)"></button>

                <!-- <button class="pswp__button pswp__button--share" title="Share"></button> -->

                <button class="pswp__button pswp__button--fs" title="Toggle fullscreen"></button>

                <button class="pswp__button pswp__button--zoom" title="Zoom in/out"></button>

                <!-- Preloader demo -->
                <!-- element will get class pswp__preloader--active when preloader is running -->
                <div class="pswp__preloader">
                    <div class="pswp__preloader__icn">
                      <div class="pswp__preloader__cut">
                        <div class="pswp__preloader__donut"></div>
                      </div>
                    </div>
                </div>
            </div>

            <div class="pswp__share-modal pswp__share-modal--hidden pswp__single-tap">
                <div class="pswp__share-tooltip"></div> 
            </div>

            <button class="pswp__button pswp__button--arrow--left" title="Previous (arrow left)">
            </button>

            <button class="pswp__button pswp__button--arrow--right" title="Next (arrow right)">
            </button>

            <div class="pswp__caption">
                <div class="pswp__caption__center"></div>
            </div>

        </div>

    </div>

</div>

<script>
	initPhotoSwipeFromDOM(".PhotoSwipe_'.$my_gallery_thisfile.'_'.$my_gallery_dir.'");
</script>';
endif;

if ($my_gallery_output_script == 'Swiper'):
$return = '';
$return .= '
<!-- Swiper -->
<div class="swiper-container SwiperSlider_'.$my_gallery_thisfile.'_'.$my_gallery_dir.'">
	<div class="swiper-wrapper">';
        if (file_exists(GSROOTPATH.'plugins/'.$my_gallery_thisfile.'/galleries/'.$my_gallery_dir.'/cache_gallery.dat')) {
			$arr = file(GSROOTPATH.'plugins/'.$my_gallery_thisfile.'/galleries/'.$my_gallery_dir.'/cache_gallery.dat', FILE_IGNORE_NEW_LINES);
			$nom = count($arr);
			if ($nom) {
				for($i = 0; $i < $nom; ++$i) {		
					$images = getimagesize(GSROOTPATH.'plugins/'.$my_gallery_thisfile.'/galleries/'.$my_gallery_dir.'/'.$arr[$i]);				
					$title = file_get_contents(GSROOTPATH.'plugins/'.$my_gallery_thisfile.'/galleries/'.$my_gallery_dir.'/title_'.$arr[$i].'_dat');
					if (strip_tags($title) == $title) { $data_type = 'img'; } else { $data_type = 'html'; }	
					if ($data_type == 'img') {
					$test_link = substr($title, 0, 4);
					$return .= '
					<div class="swiper-slide">
						'.($test_link == 'http' ? '
						<a href="'.$title.'" target="_blank">' : '').'
							<img src="'.$SITEURL.'plugins/'.$my_gallery_thisfile.'/galleries/'.$my_gallery_dir.'/'.$arr[$i].'" alt="'.($test_link != 'http' ? $title : '').'" '.($images[0] != $my_gallery_default_images_size ? 'style="width: '.$my_gallery_default_images_size.'px;"' : '').'>
						'.($test_link == 'http' ? '		
						</a>' : '').'
					</div>';
					}
					if ($data_type == 'html') {
					$return .= '
					<div class="swiper-slide">
						'.(substr($title, 0,7) == '<iframe' ? '<div class="video-wrapper">'.$title.'</div>' : '<div class="html-wrapper">'.$title.'</div>').'
					</div>';
					}
				}
			}
			else {
			  $return .= $my_gallery_msg_no_files;
			}
		} else {
			$return .= $my_gallery_msg_no_files;
		}	
$return .= '
	</div>
	<!-- Add Pagination -->
    <div class="swiper-pagination swiper-pagination_'.$my_gallery_thisfile.'_'.$my_gallery_dir.'"></div>
	<!-- Add Arrows -->
    <div class="swiper-button-next swiper-button-next_'.$my_gallery_thisfile.'_'.$my_gallery_dir.'"></div>
    <div class="swiper-button-prev swiper-button-prev_'.$my_gallery_thisfile.'_'.$my_gallery_dir.'"></div>
</div>
<script>
	var swiper_'.$my_gallery_dir.' = new Swiper(".SwiperSlider_'.$my_gallery_thisfile.'_'.$my_gallery_dir.'", {
	  slidesPerView: '.$my_gallery_default_slides_per_view.',
	  spaceBetween: 15,
      navigation: {
        nextEl: ".swiper-button-next_'.$my_gallery_thisfile.'_'.$my_gallery_dir.'",
        prevEl: ".swiper-button-prev_'.$my_gallery_thisfile.'_'.$my_gallery_dir.'",
      },
	  '.($my_gallery_default_slides_autoplay == 'checked' ? '
	  autoplay: {
        delay: 5000,
        disableOnInteraction: false,
      },
	  ' : '' ).'
      pagination: {
        el: ".swiper-pagination_'.$my_gallery_thisfile.'_'.$my_gallery_dir.'",
        clickable: true,
      },
	  on: {
		 
	   init() {
		'.($my_gallery_default_slides_autoplay == 'checked' ? '
        this.el.addEventListener("mouseenter", () => {
         this.autoplay.stop();
        });
        this.el.addEventListener("mouseleave", () => {
         this.autoplay.start();
        });
		' : '' ).'
       },
	   
	   slideChange: function() {
		MyGallery_stopVideo(".swiper-slide iframe");
	   },
		
      },
    });
</script>';
endif;

return $return;
}

// Search and replace
function ShortCodeGetMyGallery($content) {
 preg_match_all("|\[\#(.*)\#\]|U", $content, $matches);
 //print_r($matches);
 for($i = 0, $count = count($matches[1]); $i < $count; $i++) {
  $arr_tmp = explode(':', $matches[1][$i]);
  $my_gallery_dir = $arr_tmp[1]; 
  if ($matches[1][$i] == "GetMyGallery:$my_gallery_dir") {
	 $content = str_ireplace("[#GetMyGallery:$my_gallery_dir#]", GetMyGallery($my_gallery_dir), $content);
  }
 }

return $content;
}

?>