<?php
i18n_gallery_register('photoswipe', 'photoswipe', 
  '<strong>PhotoSwipe</strong> is a tool for displaying images and can display a title along with the image. It does not have a slideshow feature.<br/>'.
  'License: MIT and GPL<br/>'.
  '<a target="_blank" href="http://photoswipe.com/">http://photoswipe.com/</a>',
  'i18n_gallery_photoswipe_edit', 'i18n_gallery_photoswipe_header', 'i18n_gallery_photoswipe_content');

function i18n_gallery_photoswipe_edit($gallery) {
?>
  <p>
    <label for="photoswipe-thumbwidth"><?php i18n('i18n_gallery/MAX_THUMB_DIMENSIONS'); ?></label>
    <input type="text" class="text" id="photoswipe-thumbwidth" name="photoswipe-thumbwidth" value="<?php echo @$gallery['thumbwidth']; ?>" style="width:5em"/>
    x
    <input type="text" class="text" id="photoswipe-thumbheight" name="photoswipe-thumbheight" value="<?php echo @$gallery['thumbheight']; ?>" style="width:5em"/>
    &nbsp;
    <span id="photoswipe-thumbcrop-span">
      <input type="checkbox" id="photoswipe-thumbcrop" name="photoswipe-thumbcrop" value="1" <?php echo @$gallery['thumbcrop'] ? 'checked="checked"' : ''; ?> style="vertical-align:middle; width:auto;"/> 
      <?php i18n('i18n_gallery/CROP'); ?>
    </span>
  </p>
  <p class="inline">
    <label for="photoswipe-thumbtitles"><?php i18n('i18n_gallery/SHOW_THUMB_TITLES'); ?></label>
    <input type="checkbox" id="photoswipe-thumbtitles" name="photoswipe-thumbtitles" value="1" <?php echo @$gallery['thumbtitles'] ? 'checked="checked"' : ''; ?> />
  </p>
<?php
}

function i18n_gallery_photoswipe_header($gallery) { 
?>
	<link rel="stylesheet" href="<?php echo i18n_gallery_site_link(); ?>plugins/i18n_gallery/css/photoswipe.css" type="text/css" />
	<link rel="stylesheet" href="<?php echo i18n_gallery_site_link(); ?>plugins/i18n_gallery/css/skin/default-skin.css" type="text/css" />
<?php
}

function i18n_gallery_photoswipe_content($gallery, $pic) {
  $id = i18n_gallery_id($gallery);
  if (i18n_gallery_is_show_image($pic)) {
    $item = i18n_gallery_item($gallery, $pic);
?>
    <div class="gallery gallery-photoswipe gallery-<?php echo $id; ?>">
      <div class="gallery-image ">
        <a id="photoswipe-close" href="<?php i18n_gallery_back_link(); ?>" title="<?php i18n_gallery_BACK(); ?>"></a>      
        <h2><?php echo htmlspecialchars(@$item['_title']); ?></h2>
        <img src="<?php i18n_gallery_image_link($gallery,$pic); ?>" alt="<?php echo htmlspecialchars(@$item['_title']); ?>"/>
        <?php if (@$item['_description']) echo '<p>'.htmlspecialchars(@$item['_description']).'</p>'; ?>
        <a id="photoswipe-left" href="<?php i18n_gallery_prev_link($gallery,$pic); ?>" title="<?php i18n_gallery_PREV(); ?>"><span id="photoswipe-left-ico" class="fancy-ico"></span></a>
        <a id="photoswipe-right" href="<?php i18n_gallery_next_link($gallery,$pic); ?>" title="<?php i18n_gallery_NEXT(); ?>"><span id="photoswipe-right-ico" class="fancy-ico"></span></a>
      </div>
    </div>
<?php
  } else { 
    $thumb = i18n_gallery_thumb($gallery);
    $showtitles = i18n_gallery_check($gallery, 'thumbtitles', false);
    $pageSize = !isset($thumb) && i18n_gallery_check($gallery,'pagify',false) ? (int) $gallery['pagesize'] : 0;
?>
    <div class="row gallery-<?php echo $id; ?>" itemscope itemtype="http://schema.org/ImageGallery">
<?php 
    $i = 0;
    foreach ($gallery['items'] as $item) { 
      $text = @$item['_title'];
      if (!$text) $text = @$item['_description']; else if (@$item['_description']) $text .= ' - '.$item['_description'];
?>
	  <figure class="col-sm-6 col-md-4 col-lg-3 gallery-thumb" <?php if (isset($thumb) && $thumb != $i) echo 'style="display:none"'; ?> itemprop="associatedMedia" itemscope itemtype="http://schema.org/ImageObject">
        <a class="thumbnail" href="<?php i18n_gallery_image_link($gallery,$item); ?>" title="<?php echo htmlspecialchars(@$item['_title']); ?>" itemprop="contentUrl" data-size="<?php echo $item['width'] . "x" . $item['height']; ?>">
          <img class="img-responsive" src="<?php i18n_gallery_thumb_link($gallery,$item); ?>" itemprop="thumbnail" alt="<?php echo htmlspecialchars(@$item['_title']); ?>"/>
        </a>
        <figcaption class="gallery-title caption<?php if ($showtitles) { ?> vision<?php } ?>" itemprop="caption description"><h4><?php echo htmlspecialchars(@$item['_title']); ?></h4> <div><?php echo htmlspecialchars(@$item['_description']); ?></div></figcaption>
      </figure>
<?php
      $i++; 
    } 
?>
    </div>

<div class="pswp" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="pswp__bg"></div>
    <div class="pswp__scroll-wrap">
        <div class="pswp__container">
            <div class="pswp__item"></div>
            <div class="pswp__item"></div>
            <div class="pswp__item"></div>
        </div>
        <div class="pswp__ui pswp__ui--hidden">
            <div class="pswp__top-bar">
                <div class="pswp__counter"></div>
                <button class="pswp__button pswp__button--close" title="Close (Esc)"></button>
                <button class="pswp__button pswp__button--share" title="Share"></button>
                <button class="pswp__button pswp__button--fs" title="Toggle fullscreen"></button>
                <button class="pswp__button pswp__button--zoom" title="Zoom in/out"></button>
                <div class="pswp__preloader">
                    <div class="pswp__preloader__icn">
						<div class="pswp__preloader__cut">
							<div class="pswp__preloader__donut"></div>
						</div>
                    </div>
                </div>				
            </div>
            <div class="pswp__share-modal pswp__share-modal--hidden pswp__single-tap">
                <div class="pswp__share-tooltip"></div> 
            </div>
            <button class="pswp__button pswp__button--arrow--left" title="Previous (arrow left)">
            </button>
            <button class="pswp__button pswp__button--arrow--right" title="Next (arrow right)">
            </button>
            <div class="pswp__caption">
                <div class="pswp__caption__center"></div>
            </div>
        </div>
    </div>
</div>
	<script type="text/javascript" src="<?php echo i18n_gallery_site_link(); ?>plugins/i18n_gallery/js/photoswipe-ui-default.min.js"></script>
    <script type="text/javascript" src="<?php echo i18n_gallery_site_link(); ?>plugins/i18n_gallery/js/photoswipe.min.js"></script>
	<script type="text/javascript" src="<?php echo i18n_gallery_site_link(); ?>plugins/i18n_gallery/js/custom.js"></script>
    <script type="text/javascript">
		initPhotoSwipeFromDOM('.gallery-<?php echo $id; ?>');
	</script>

<?php
  }
}
