<?php
$thisfileid = basename(__FILE__, '.php');
include(__DIR__.'/'.$thisfileid.'/inc/_inc.php');

register_plugin(
	basename($thisfileid, '.php'),
	\ImCatalog\Util::i18n_r('plugin_name'),
	'0.4',
	'Juri Ehret',
	'http://ehret-studio.com',
	\ImCatalog\Util::i18n_r('plugin_description'),
	'pages',
	'im_catalog_init'
);

if(defined('IS_ADMIN_PANEL'))
{
	register_style('imscstyle',
		$SITEURL.'plugins/'.$thisfileid.'/css/admin/styles.css',GSVERSION, 'screen');
	register_style('scsliderstyle',
		$SITEURL.'plugins/'.$thisfileid.'/slider/styles/slider.css', GSVERSION, 'screen');
	register_style('slidersample',
		$SITEURL.'plugins/'.$thisfileid.'/slider/styles/example.css', GSVERSION, 'screen');
	queue_style('imscstyle',GSBACK);
	queue_style('scsliderstyle',GSBACK);
	queue_style('slidersample', GSBACK);
}
register_style('scstyle',
	$SITEURL.'plugins/'.$thisfileid.'/css/frontend/styles.css',GSVERSION, 'screen');
queue_style('scstyle',GSFRONT);

add_action('admin-pre-header', 'aj_catalog_init');
add_action('pages-sidebar', 'createSideMenu',
	array($thisfileid, \ImCatalog\Util::i18n_r('admin_tab_label')));
add_action( 'index-post-dataindex', '__im_dataindex');

function im_catalog_init()
{
	if(!defined('IS_ADMIN_PANEL')) return;
	$catalog = imCatalogBuilder();
	$catalog->trigger->watchAdminActions();
	echo $catalog->renderAdmin();
}

function aj_catalog_init()
{
	if(!isset($_GET['sccatlist']) && !isset($_GET['scitemlist'])) return;
	if(!defined('IS_ADMIN_PANEL')) return;
	$catalog = imCatalogBuilder();
	$catalog->trigger->watchAdminActions();
	echo (isset($_GET['sccatlist']) ? $catalog->renderAdminCategoryListRows() : $catalog->renderAdminItemListRows());
	exit();
}

function __im_dataindex()
{
	global $catalog;
	$catalog = imCatalogBuilder();
	$catalog->trigger->watchFrontendActions();
	$catalog->renderFrontend();
}