<?php namespace ImCatalog;

class Util
{
	public static $key = 'id';

	public static function i18n_r($hash)
	{
		global $thisfileid;
		return \i18n_r($thisfileid.'/'.$hash);
	}


	/**
	 * Build SimpleCatalog configuration
	 *
	 * @return Config object
	 */
	public static function buildConfig()
	{
		global $thisfileid, $id;
		$config = new Config();
		if(!file_exists(__DIR__.'/config.php')) { include(dirname(__DIR__).'/install/installer.php'); }
		include(__DIR__.'/config.php');
		if(file_exists(__DIR__.'/custom.config.php')) { include(__DIR__.'/custom.config.php'); }
		$config->pluginRoot = dirname(__DIR__);
		$config->pageSlug = $id;
		$config->catalogStartPage = self::getLastSegments($config->startPageUri);
		$config->searchResultPage = self::getLastSegments($config->searchResultPageUri);
		$config->requestUri = $_SERVER['REQUEST_URI'];
		$config->pluginId = $thisfileid;
		return $config;
	}

	protected static function getLastSegments($catalogStartPage)
	{
		$parts = explode('/', trim($catalogStartPage, '/'));
		return end($parts);
	}

	/**
	 * Returns URL to resized image
	 * With the first call creates thumbnail and cached it
	 *
	 * @param object $image   - An SimpleItem object
	 * @param integer $id     - An index of the image field
	 * @param integer $width  - Thumb width
	 * @param integer $height - Thumb height
	 *
	 * @return string - The image url indexed by $id
	 *
	 */
	public static function getResizedUrl(\SimpleItem $item, $id = 0, $width = 200, $height = 0, $type = 'adaptiveResize')
	{
		global $SITEURL;
		if(empty($item->image[$id])) return;
		if(!file_exists(GSROOTPATH.$item->image[$id])) return;
		$relpath = dirname(@$item->image[$id]);
		$path = dirname(GSROOTPATH.$item->image[$id]);
		$base = basename(GSROOTPATH.$item->image[$id]);
		if(!file_exists($path.'/thumbnail/'.$width.'x'.$height.'_'.$base)) {
			$thumb = \PhpThumbFactory::create(GSROOTPATH.$item->image[$id]);
			$path_parts = pathinfo(GSROOTPATH.$item->image[$id]);
			$thumb->{$type}($width, $height);
			$thumb->save($path.'/thumbnail/'.$width.'x'.$height.'_'.$base, $path_parts['extension']);
		}
		return $SITEURL.$relpath.'/thumbnail/'.$width.'x'.$height.'_'.$base;
	}


	/**
	 * Sorts the array
	 *
	 * @param $a|$b arrays to be sorted
	 * @param $key the array key to be sort
	 *
	 * @return boolean
	 */
	public static function sortArray($a, $b)
	{
		$a = $a[self::$key];
		$b = $b[self::$key];
		if(is_numeric($a))
		{
			if($a == $b) {return 0;}
			else
			{
				if($b > $a) {return -1;}
				else {return 1;}
			}
		} else {return strcasecmp($a, $b);}
	}

}

class DashboardData
{
	/**
	 * Provides direct reference access to set values in the $data array
	 *
	 * @param string $key
	 * @param mixed $value
	 * return $this
	 *
	 */
	public function __set($key, $value) {
		$this->{$key} = $value;
	}
}