<?php if(!defined('IN_GS')){ die('you cannot load this page directly.'); }

class Installer
{
	public static $output = array();
	private static $dummyCategory;
	private static $indexData;
	private static $indexDataDashboardId = 1;
	private static $indexDataRoutesId = 2;

	/**
	 * Check correctly installation step by step
	 */
	public static function checkInstallation()
	{
		global $thisfileid;
		$success = true;
		self::$output[] = '<p>Starting the installation process:</p>';
		self::$output[] = '<ul class="msgs">';

		// Check ItemManager installed
		if(!self::isItemManagerInstalled())
		{
			self::$output[] = '<li class="error">You need the <a href="http://get-simple.info/extend/plugin/itemmanager/936/">ItemManager</a> plugin installed to run the SimpleCatalog, 
which has obviously not been installed yet.</li>';
			$success = false;
		} else
		{
			self::$output[] = '<li class="notify">ItemManager seems already to be installed.</li>';
		}

		self::$output[] = '</ul>';

		self::$output[] = '<ul class="msgs">';
		// Check ItemManager installed
		if(!self::isAllocatorEnabled())
		{
			self::$output[] = '<li class="error">The variable useAllocater is disabled, change the 
$config->useAllocater valiable in <strong>/plugins/imanager/inc/config.php</strong> to: true</li>';
			$success = false;
		}
		self::$output[] = '</ul>';
		self::$output[] = '<ul class="msgs">';
		// Check ItemManager installed
		if(!self::checkItemManagerVersion())
		{
			self::$output[] = '<li class="error">ItemManager version is older than v. 2.4.0, a newer version of the 
ItemManager is required to get SimpleCatalog running.</li>';
			$success = false;
		}
		self::$output[] = '</ul>';
		if(!$success) {
			self::$output[] = '<p><br>Installation is cancelled.</p>';
			self::output();
		}

		self::$output[] = '<p><br>Checking whether the Dummy Category already exists:</p>';
		self::$output[] = '<ul class="msgs">';

		if(!self::dummyCategoryExists())
		{
			self::$output[] = '<li class="error">The Dummy Category does not exists.</li>';
			$success = false;
		} else
		{
			self::$output[] = '<li class="notify">The Dummy Category already exists.</li>';
		}

		self::$output[] = '</ul>';

		if(!$success)
		{
			$success = true;
			self::$output[] = '<p><br>Trying to create the Dummy Category:</p>';
			self::$output[] = '<ul class="msgs">';

			if(!self::createDummyCategory())
			{
				self::$output[] = '<li class="error">The Dummy Category could not be created.</li>';
				$success = false;
			} else
			{
				self::$output[] = '<li class="notify">The Dummy Category was created successfully.</li>';
			}

			self::$output[] = '</ul>';
			if(!$success) {
				self::$output[] = '<p><br>Installation is cancelled.</p>';
				self::output();
			}
		}

		self::$output[] = '<p><br>Checking whether the IndexData category already exists:</p>';
		self::$output[] = '<ul class="msgs">';

		if(!self::indexDataCategoryExists())
		{
			self::$output[] = '<li class="error">The IndexData category does not exist.</li>';
			$success = false;
		} else
		{
			self::$output[] = '<li class="notify">The IndexData category already exists.</li>';
		}

		if(!$success)
		{
			$success = true;
			self::$output[] = '<p><br>Trying to create the IndexData category:</p>';
			self::$output[] = '<ul class="msgs">';

			if(!self::createIndexCategory())
			{
				self::$output[] = '<li class="error">The IndexData category could not be created.</li>';
				$success = false;
			} else
			{
				self::$output[] = '<li class="notify">The IndexData category was created successfully.</li>';
			}

			self::$output[] = '</ul>';
			if(!$success) {
				self::$output[] = '<p><br>Installation is cancelled.</p>';
				self::output();
			}

		}

		self::createDashboardItems();
		self::createRoutesItem();

		self::$output[] = '<p><br>Creating SimpleCatalog configuration file:</p>';
		self::$output[] = '<ul class="msgs">';

		if(!self::createConfig())
		{
			self::$output[] = '<li class="error">The config.php file could not be created.</li>';
			$success = false;
		} else
		{
			self::$output[] = '<li class="notify">The <strong>'.dirname(__DIR__).'/inc/config.php</strong> file was created successfully.</li>';
		}

		self::$output[] = '</ul>';
		if(!$success) {
			self::$output[] = '<p><br>Installation is cancelled.</p>';
			self::output();
		}

		if($success) {
			self::$output[] = '<p><br><strong>The SimpleCatalog plugin installation is successfully completed.</strong></p>';
			self::$output[] = '<form method="post" action="load.php?id='.$thisfileid.'">
				<div class="form-control"><input class="submit" type="submit" name="submit" 
					value="Go to the SimpleCatalog"></div></form>';
		}
		self::output();
	}


	private static function output() {
		foreach(self::$output as $line) { echo $line; }
		exit();
	}


	private static function isItemManagerInstalled()
	{
		if(!function_exists('imanager')) {return false;}
		$imanager = imanager();
		if($imanager::$installed !== true) {return false;}
		return true;
	}


	private static function isAllocatorEnabled()
	{
		if(!function_exists('imanager')) {return false;}
		if(imanager()->config->useAllocater !== true) {return false;}
		return true;
	}

	private static function checkItemManagerVersion()
	{
		if(!function_exists('imanager')) {return false;}
		imanager();
		if(!defined('IM_VERSION')) return;
		elseif(IM_VERSION < 240) {return false;}
		return true;
	}


	private static function dummyCategoryExists()
	{
		$imanager = imanager();
		if((self::$dummyCategory = $imanager->getCategoryMapper()->getCategory('name=Dummy Category')) !== false)
			{return true;}
		return false;
	}

	private static function indexDataCategoryExists()
	{
		$imanager = imanager();
		if((self::$indexData = $imanager->getCategoryMapper()->getCategory('name=IndexData')) !== false)
		{return true;}
		return false;
	}


	private static function createDummyCategory()
	{
		global $thisfileid;
		$imanager = imanager();
		// Use ItemManager's language file
	 	MsgReporter::$dir = 'imanager';
		if($imanager->createCategoryByName('Dummy Category', true) !== true) return false;

		self::$dummyCategory = $imanager->getCategoryMapper()->getCategory('name=Dummy Category');
		if(!self::$dummyCategory) return false;

		$fields = array(
			'cat' => self::$dummyCategory->id,

			'cf_0_key'   => 'slug',
			'cf_0_label' => 'Category Slug',
			'cf_0_type'  => 'slug',
			'cf_0_options' => '',
			'cf_0_value' => '',

			'cf_1_key'   => 'description',
			'cf_1_label' => 'Description',
			'cf_1_type'  => 'editor',
			'cf_1_options' => '',
			'cf_1_value' => '',

			'cf_2_key'   => 'image',
			'cf_2_label' => 'Images',
			'cf_2_type'  => 'fileupload',
			'cf_2_options' => '',
			'cf_2_value' => '',

			'cf_3_key'   => 'metatitle',
			'cf_3_label' => 'Meta title',
			'cf_3_type'  => 'text',
			'cf_3_options' => '',
			'cf_3_value' => '',

			'cf_4_key'   => 'metadescription',
			'cf_4_label' => 'Meta description',
			'cf_4_type'  => 'text',
			'cf_4_options' => '',
			'cf_4_value' => ''
		);
		// Create fields
		if($imanager->createFields($fields) !== true) {
			$imanager->deleteCategory(self::$dummyCategory->id);
			return false;
		}
		// Default product category field data
		$fieldsdata = array(
			array(
				'field' => 1,
				'default' => '',
				'info' => '',
				'required' => 0,
				'min_field_input' => 0,
				'max_field_input' => 0,
				'areaclass' => '',
				'labelclass' => '',
				'fieldclass' => ''
			),
			array(
				'field' => 2,
				'default' => '',
				'info' => '',
				'required' => 0,
				'min_field_input' => 0,
				'max_field_input' => 0,
				'areaclass' => '',
				'labelclass' => '',
				'fieldclass' => ''
			),
			array(
				'field' => 3,
				'default' => '',
				'info' => '',
				'required' => 0,
				'min_field_input' => 0,
				'max_field_input' => 0,
				'areaclass' => '',
				'labelclass' => '',
				'fieldclass' => '',
				'custom-accept_types' => 'gif|jpe?g|png'
			),
			array(
				'field' => 4,
				'default' => '',
				'info' => '',
				'required' => 0,
				'min_field_input' => 0,
				'max_field_input' => 0,
				'areaclass' => '',
				'labelclass' => '',
				'fieldclass' => ''
			),
			array(
				'field' => 5,
				'default' => '',
				'info' => '',
				'required' => 0,
				'min_field_input' => 0,
				'max_field_input' => 0,
				'areaclass' => '',
				'labelclass' => '',
				'fieldclass' => ''
			),
		);
		// Set field data
		if(self::setFiedData(self::$dummyCategory->id, $fieldsdata) !== true) {
			$imanager->deleteCategory(self::$dummyCategory->id);
			return false;
		}
		// Switch back to the SimpleCatalog language file
		MsgReporter::$dir = $thisfileid;
		return true;
	}

	private static function setFiedData($catid, $fieldsdata)
	{
		$cf = new FieldMapper();
		$cf->init($catid);

		foreach($fieldsdata as $input)
		{
			// Field already exists
			$currfield = $cf->getField((int)$input['field']);

			if(!$currfield)
			{
				MsgReporter::setClause('err_field_id', array(), true);
				return false;
			}

			$currfield->default = !empty($input['default']) ? str_replace('"', "'", $input['default']) : '';
			$currfield->info = !empty($input['info']) ? str_replace('"', "'", $input['info']) : '';
			$currfield->required = (isset($input['required']) && $input['required'] > 0) ? 1 : null;
			$currfield->minimum = (isset($input['min_field_input']) && intval($input['min_field_input']) > 0)
				? intval($input['min_field_input']) : null;
			$currfield->maximum = (isset($input['max_field_input']) && intval($input['max_field_input']) > 0)
				? intval($input['max_field_input']) : null;
			$currfield->areaclass = !empty($input['areaclass']) ? str_replace('"', "'", $input['areaclass']) : '';
			$currfield->labelclass = !empty($input['labelclass']) ? str_replace('"', "'", $input['labelclass']) : '';
			$currfield->fieldclass = !empty($input['fieldclass']) ? str_replace('"', "'", $input['fieldclass']) : '';

			// process custom Fieldtype settings
			foreach($input as $key => $value)
			{
				if(strpos($key, 'custom-') !== false)
				{
					$fieldkey = str_replace('custom-', '', $key);
					$currfield->configs->$fieldkey = $value;
				}
			}
			if(!$currfield->save()) return false;
		}
		return true;
	}


	private static function createIndexCategory()
	{
		global $thisfileid;
		$imanager = imanager();
		// Use ItemManager's language file
		MsgReporter::$dir = 'imanager';
		if($imanager->createCategoryByName('IndexData', true) !== true) return false;

		self::$indexData = $imanager->getCategoryMapper()->getCategory('name=IndexData');
		if(!self::$indexData) return false;

		$fields = array(
			'cat' => self::$indexData->id,

			'cf_0_key'   => 'data',
			'cf_0_label' => 'SimpleCatalog index data',
			'cf_0_type'  => 'text',
			'cf_0_options' => '',
			'cf_0_value' => '',
		);
		// Create fields
		if($imanager->createFields($fields) !== true) {
			$imanager->deleteCategory(self::$indexData->id);
			return false;
		}

		$fieldsdata = array(
			array(
				'field' => 1,
				'default' => '',
				'info' => '<span class="redtext">Please never change or delete this data!</span>',
				'required' => 0,
				'min_field_input' => 0,
				'max_field_input' => 0,
				'areaclass' => '',
				'labelclass' => '',
				'fieldclass' => 'readonly'
			)
		);

		// Set field data
		if(self::setFiedData(self::$indexData->id, $fieldsdata) !== true) {
			$imanager->deleteCategory(self::$indexData->id);
			return false;
		}
		// Switch back to the SimpleCatalog language file
		MsgReporter::$dir = $thisfileid;
		return true;
	}

	private static function createDashboardItems()
	{
		global $thisfileid;
		$mapper = imanager()->getItemMapper();

		$mapper->init(self::$indexData->id);
		$item = $mapper->getItem('label=dashboard_01');

		if($item === false) {
			$item = new Item(self::$indexData->id);
			$item->name = 'Dashboard Data';
			$item->label = 'dashboard_01';
			$item->active = 1;
			$data = new \ImCatalog\DashboardData();
			$data->itemsTotal = 0;
			$data->categoriesTotal = 0;
			$data->recentItems[0]['id'] = null;
			$data->recentItems[0]['categoryid'] = null;
			$data->recentItems[1]['id'] = null;
			$data->recentItems[1]['categoryid'] = null;
			$data->recentItems[2]['id'] = null;
			$data->recentItems[2]['categoryid'] = null;
			$data->recentItems[3]['id'] = null;
			$data->recentItems[3]['categoryid'] = null;
			$data->showSlider = true;
			$data->createdBy = '<a href="ehret-studio.com">ehret studio</a>';
			$data->createrMail = '<a href="mailto:juri.ehret@gmail.com">juri.ehret@gmail.com</a>';
			$data->createrPhone = ' <a href="tel:+4915203939576">+49 152 03939576</a>';
			$data->helpUrl = '<a href="https://ehret-studio.com/lab/itemmanager/">ItemManager</a>';
			$value = base64_encode(serialize($data));
			$item->setFieldValue('data', $value, false);
			$item->save();
		}

		self::$indexDataDashboardId = $item->id;
		// Save SimpleItem object
		if($mapper->alloc(self::$indexData->id) !== true)
		{
			$mapper->init(self::$indexData->id);
			if(!empty($mapper->items))
			{
				$mapper->simplifyBunch($mapper->items);
				$mapper->save();
			}
		}
		$mapper->simplify($item);
		$mapper->save();

	}

	private static function createRoutesItem()
	{
		global $thisfileid;
		$mapper = imanager()->getItemMapper();

		$mapper->init(self::$indexData->id);
		$item = $mapper->getItem('label=routes_01');

		if($item === false) {
			$item = new Item(self::$indexData->id);
			$item->name = 'Simple Catalog Routes';
			$item->label = 'routes_01';
			$item->active = 1;
			$data = new \ImCatalog\Route();
			$value = serialize($data);
			$item->setFieldValue('data', $value, false);
			$item->save();
		}

		self::$indexDataRoutesId = $item->id;
		// Save SimpleItem object
		if($mapper->alloc(self::$indexData->id) !== true)
		{
			$mapper->init(self::$indexData->id);
			if(!empty($mapper->items))
			{
				$mapper->simplifyBunch($mapper->items);
				$mapper->save();
			}
		}
		$mapper->simplify($item);
		$mapper->save();

	}

	private static function createConfig()
	{
		$dci  = self::$dummyCategory->id;
		$idi  = self::$indexData->id;
		$iddi = self::$indexDataDashboardId;
		$idri = self::$indexDataRoutesId;

		$data =
<<<EOD
<?php if(!defined('IN_GS')){ die('you cannot load this page directly.'); }
/**
 * SimpleCatalog automatically populates several entries into \$config and
 * then includes your plugin-specific entries stored in this file.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * NOTE: DO NOT DELETE OR CHANGE VARIABLES IN THIS FILE!
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 * If you would like to change the SimpleCatalog settings you should create your own config
 * file 'custom.config.php' in the same directory. To do so, simply copy the config.php
 * complete file and rename it to 'custom.config.php'. SimpleCatalog will load its at
 * runtime and read it's content, the entries in config.php will be overwritten by your
 * custom.config.php settings.
 */
\$config->debug = true;

\$config->adminCatPerPage = 10;

\$config->frontendCatPerPage = 10;

\$config->adminItemsPerPage = 10;

\$config->frontendItemsPerPage = 10;

\$config->dummyCategoryId = {$dci};

\$config->indexDataId = {$idi};

\$config->indexDataDashboardId = {$iddi};

\$config->indexDataRoutesId = {$idri};

// Change to true the SectionCache to speed up the rendering for large pages
\$config->useSectionCache = false;

\$config->sectionCacheTime = 3600;

\$config->replaceContent = true;

\$config->scatteredOutput = false;

\$config->displayCategoryListSearchForm = true;

\$config->displayCategoryListHeader = true;

\$config->displayItemListSearchForm = true;

\$config->displayItemListHeader = true;

\$config->displayBreadcrumbs = true;

\$config->displayItemDetailsSearchForm = true;

\$config->displayItemDetailsHeader = true;

\$config->displaySearchResultSearchForm = true;

\$config->displaySearchResultHeader = true;

\$config->displayItemListTags = true;

/*
 * Your GetSimple catalog page - NOTE: must physically exist!
 * You can freely define the name of this page.
 *
 * Examples:
 * 1. If your physically existent page is under http://www.mypage.com/catalog/,
 *    so you can enter here '/catalog/'
 * 2. If your page is under http://www.mypage.com/foo/catalog/, so you should
 *    enter '/foo/catalog/' etc.
 * 3. If you've installed GetSimple in a subdirectory http://www.mypage.com/subdirectory/catalog/
 *    enter '/subdirectory/catalog/'
 */
\$config->startPageUri = '/catalog/';

/*
 * Your catalog search page - NOTE: must physically exist and must be a child of 
 * catalog page you have created. You can freely define the name of this page.
 */
\$config->searchResultPageUri = '/catalog/search-results/';

\$config->searchResultImageResize = true;

// The content of these fields will also be used for search
\$config->searchableFields = array(
	'name',
	'tags'
);

\$config->shortenSearchOutput = true;

\$config->searchOutputChars = 160;

// There you can include a trailing slash to your URL links or leave this variable empty ''
\$config->trailingSlash = '/';

\$config->cleanPageNumbers = false;

\$config->categoryImageResize = true;

\$config->itemListImageResize = true;

\$config->itemDetailsImageResize = true;

\$config->itemDetailsImageSizes = array(
	0 => array('w' => 600, 'h' => 600),
	1 => array('w' => 300, 'h' => 300),
	2 => array('w' => 300, 'h' => 300)
);

\$config->categoryImageMaxWidth = 300;

\$config->categoryImageMaxHeight = 300;

\$config->itemListImageMaxWidth = 300;

\$config->itemListImageMaxHeight = 300;

\$config->categoryImageIndex = 0;

\$config->itemListImageIndex = 0;

\$config->searchResultImageMaxWidth = 40;

\$config->searchResultImageMaxHeight = 40;

\$config->searchResultImageIndex = 0;

/**
 * 'page'
 * '?page='
 *
 * RewriteCond %{REQUEST_FILENAME} !-f
 * RewriteCond %{REQUEST_FILENAME} !-d
 * RewriteRule ^([^/]+)/(page[0-9]+)$ index.php?id=$1&page=$2 [QSA,L]
 *
 * RewriteCond %{REQUEST_FILENAME} !-f
 * RewriteCond %{REQUEST_FILENAME} !-d
 * RewriteRule /?([A-Za-z0-9-]+)/?$ index.php?id=$1 [QSA,L]
 */
\$config->pageNumberParam = '?page=';

\$config->timeFormat = 'Y-m-d H:i:s';

\$config->catAutoActivate = true;

\$config->itemAutoActivate = true;

EOD;



//		$data = "<?php if(!defined('IN_GS')){ die('you cannot load this page directly.'); }\r\n";
//		$data .= "/**\r\n";
//		$data .= " * SimpleCatalog automatically populates several entries into \$config and\r\n";
//		$data .= " * then includes your plugin-specific entries stored in this file.\r\n";
//		$data .= " *\r\n";
//		$data .= " * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\r\n";
//		$data .= " * NOTE: DO NOT DELETE OR CHANGE VARIABLES IN THIS FILE!\r\n";
//		$data .= " * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\r\n";
//		$data .= " *\r\n";
//		$data .= " * If you want to change the SimpleCatalog settings you should create your own config\r\n";
//		$data .= " * file 'custom.config.php' in the same directory. To do so, simply copy the config.php\r\n";
//		$data .= " * complete file and rename it to 'custom.config.php'. SimpleCatalog will load its at\r\n";
//		$data .= " * runtime and read it's content, the entries in config.php will be overwritten by your\r\n";
//		$data .= " * custom.config.php settings.\r\n";
//		$data .= " */\r\n";
//		$data .= '$config->debug = true;'."\r\n\r\n";
//		$data .= '$config->adminCatPerPage = 10;'."\r\n\r\n";
//		$data .= '$config->frontendCatPerPage = 10;'."\r\n\r\n";
//		$data .= '$config->adminItemsPerPage = 10;'."\r\n\r\n";
//		$data .= '$config->frontendItemsPerPage = 10;'."\r\n\r\n";
//		$data .= '$config->dummyCategoryId = '.self::$dummyCategory->id.";\r\n\r\n";
//		$data .= '$config->indexDataId = '.self::$indexData->id.";\r\n\r\n";
//		$data .= '$config->indexDataDashboardId = '.self::$indexDataDashboardId.";\r\n\r\n";
//		$data .= '$config->indexDataRoutesId = '.self::$indexDataRoutesId.";\r\n\r\n";
//		$data .= '$config->replaceContent = true;'."\r\n\r\n";
//		$data .= '$config->scatteredOutput = false;'."\r\n\r\n";
//		$data .= '$config->displayCategoryListSearchForm = true;'."\r\n\r\n";
//		$data .= '$config->displayCategoryListHeader = true;'."\r\n\r\n";
//		$data .= '$this->displayItemListSearchForm = true;'."\r\n\r\n";
//		$data .= '$this->displayItemListHeader = true;'."\r\n\r\n";
//		$data .= '$config->catalogStartPage = \'index\';'."\r\n\r\n";
//		$data .= '$config->searchResultPage = \'index\';'."\r\n\r\n";
//		$data .= '$config->cleanPageNumbers = false;'."\r\n\r\n";
//		$data .= '$config->displayItemListHeader = false;'."\r\n\r\n";
//		$data .= '$config->categoryImageResize = true;'."\r\n\r\n";
//		$data .= '$config->itemListImageResize = true;'."\r\n\r\n";
//		$data .= '$config->categoryImageMaxWidth = 300;'."\r\n\r\n";
//		$data .= '$config->categoryImageMaxHeight = 300;'."\r\n\r\n";
//		$data .= '$config->categoryImageIndex = 0;'."\r\n\r\n";
//		$data .= "/**\r\n\r\n";
//		$data .= " * 'page'\r\n\r\n";
//		$data .= " * '?page='\r\n\r\n";
//		$data .= " *\r\n\r\n";
//		$data .= " * RewriteCond %{REQUEST_FILENAME} !-f\r\n\r\n";
//		$data .= " * RewriteCond %{REQUEST_FILENAME} !-d\r\n\r\n";
//		$data .= " * RewriteRule ^([^/]+)/(page[0-9]+)$ index.php?id=$1&page=$2 [QSA,L]\r\n\r\n";
//		$data .= " *\r\n\r\n";
//		$data .= " * RewriteCond %{REQUEST_FILENAME} !-f\r\n\r\n";
//		$data .= " * RewriteCond %{REQUEST_FILENAME} !-d\r\n\r\n";
//		$data .= " * RewriteRule /?([A-Za-z0-9-]+)/?$ index.php?id=$1 [QSA,L]\r\n\r\n";
//		$data .= " */\r\n\r\n";
//		$data .= '$config->pageNumberParam = \'?page=\';'."\r\n\r\n";
//		$data .= '$config->timeFormat = \'Y-m-d H:i:s\';'."\r\n\r\n";
//		$data .= '$config->catAutoActivate = true;'."\r\n\r\n";
//		$data .= '$config->itemAutoActivate = true;'."\r\n";
//		$data .= "\r\n";
		$fp = fopen(dirname(__DIR__).'/inc/config.php','w');
		$fwrite = fwrite($fp, $data);
		if($fwrite === false) {
			fclose($fp);
			return false;
		}
		return true;
	}
}

Installer::checkInstallation();

exit();