<?php namespace ImCatalog;

class Factory
{
	protected static $config;
	protected static $catalog;
	protected static $router;
	protected static $processor;
	protected static $trigger;

	public static function buildCatalog(Controller $controller)
	{
		self::$config = !self::$config ? Util::buildConfig() : '';
		self::$router = !self::$router ? new Router(self::$config) : self::$router;
		self::$processor = !self::$processor ? new Processor(self::$config, self::$router) : self::$processor;
		self::$trigger = !self::$trigger ? new ActionsTrigger(self::$processor) : self::$trigger;
		$controller->init(self::$processor, self::$trigger);
		self::$catalog = $controller;
	}

	public static function getCatalog() { return self::$catalog; }
}