<?php namespace ImCatalog;

class Router
{
	private $config;

	private $mapper;

	private $flag;

	public $routes;

	public $total;

	public $currentRoute;

	protected $sanitizer;

	public $catalogPage = false;


	public function __construct(Config $config)
	{
		$this->config = $config;
		$imanager = imanager();
		$this->mapper = $imanager->getItemMapper();
		$this->sanitizer = $imanager->sanitizer;
		$this->flag = false;
		$this->loadRoutes();
		if(!empty($this->routes)) $this->setCatalogRoutes($this->config->pageSlug);
	}


	private function loadRoutes()
	{
		$this->mapper->alloc($this->config->indexDataId);
		$this->routes = !empty($this->mapper->simpleItems[$this->config->indexDataRoutesId]) ?
			unserialize($this->mapper->simpleItems[$this->config->indexDataRoutesId]->data) : new Route();
		$this->total = count($this->routes);
		$this->mapper->simpleItems = null;
	}


	private function setPhysicalRoute($routeid)
	{
		global $id, $url, $content, $title, $metak, $metad, $template_file;

		$data_index = getXml(GSDATAPAGESPATH . $routeid . '.xml');
		$id = $routeid;
		$url = $routeid;
		$content = $data_index->content;
		$parent = $data_index->parent;
		$title = $data_index->title;
		$metak = $data_index->meta;
		$metad = $data_index->metad;
		$template_file = $data_index->template;
	}


	private function setCatalogRoutes($id)
	{
		if(!$this->compare($this->config->requestUri, $this->config->startPageUri)) return;

		// http://site.com/foo/catalog/
		if($id == $this->config->catalogStartPage) {
			$this->catalogPage = true;
			$this->setPhysicalRoute($this->config->catalogStartPage);
			return;
		// http://site.com/foo/catalog/search-page/
		} elseif($this->compare($this->config->requestUri, $this->config->searchResultPageUri))
		{
			if($id == $this->config->searchResultPage) {
				$this->catalogPage = true;
				$this->setPhysicalRoute($this->config->searchResultPage);
				return;
			}
		}
		// http://site.com/foo/catalog/category-name/ or http://site.com/foo/catalog/category-name/item-name/
		elseif($this->isRouteExists($id))
		{
			// http://site.com/foo/catalog/category-name/
			if($this->routes->{$id}['type'] == 1 &&
				$this->compare($this->config->requestUri,
					$this->config->startPageUri.$id.$this->config->trailingSlash)) {
				$this->catalogPage = true;
				$this->currentRoute = $this->routes->{$id};
				$this->currentRoute['slug'] = $id;
				$this->setPhysicalRoute($this->config->catalogStartPage);
				return;
			}
			// http://site.com/foo/catalog/category-name/item-name/
			$this->mapper->alloc($this->config->dummyCategoryId, $this->routes->{$id}['categoryid']);
			$item = !empty($this->mapper->simpleItems[$this->routes->{$id}['categoryid']]) ?
				$this->mapper->simpleItems[$this->routes->{$id}['categoryid']] : null;
			if($this->routes->{$id}['type'] == 2 &&
				$this->compare($this->config->requestUri,
					$this->config->startPageUri.$item->slug.'/'.$id.$this->config->trailingSlash)) {
				$this->catalogPage = true;
				$this->currentRoute = $this->routes->{$id};
				$this->currentRoute['slug'] = $id;
				$this->setPhysicalRoute($this->config->catalogStartPage);
				return;
			}
		}
	}

	private function compare($a, $b) { return (strncmp($a, $b, strlen($b)) === 0) ? true : false; }


	public function isRouteExists($slug) { return (isset($this->routes->{$slug}) ? true : false); }


	public function setRoute($item, $type)
	{
		$this->routes->{$item->fields->slug->value} = array('id' => $item->id, 'categoryid' => $item->categoryid,
			'type' => $type);
		$this->flag = true;
		$this->total++;
	}

	public function getRoute($slug) {return (isset($this->routes->{$slug}) ? $this->routes->{$slug} : null); }


	public function removeRoute($slug)
	{
		if($this->isRouteExists($slug) === true) unset($this->routes->{$slug});
		$this->flag = true;
		$this->total--;
	}


	public function saveRoutes()
	{
		$this->mapper->limitedInit($this->config->indexDataId, $this->config->indexDataRoutesId);

		$item = $this->mapper->items[$this->config->indexDataRoutesId];
		if($item === false) {
			\MsgReporter::setClause('err_saving_indexdata', array(), true);
			return false;
		}
		$item->setFieldValue('data', serialize($this->routes), false);
		$item->save();
		if($this->mapper->alloc($this->config->indexDataId) !== true)
		{
			$this->mapper->init($this->config->indexDataId);
			if(!empty($this->mapper->items))
			{
				$this->mapper->simplifyBunch($this->mapper->items);
				$this->mapper->save();
			}
		}
		$this->mapper->simplify($item);
		$this->mapper->save();
	}


	function __destruct() {
		if($this->flag) $this->saveRoutes();
	}

}

class Route
{
	/**
	 * Provides direct reference access to set values in the $data array
	 *
	 * @param string $key
	 * @param mixed $value
	 * return $this
	 *
	 */
	public function __set($key, $value) {
		$this->{$key} = $value;
	}
}