<?php namespace ImCatalog;

class ActionsTrigger
{
	private $processor;

	public function __construct(Processor $processor)
	{
		$this->processor = $processor;
	}

	public function watchAdminActions()
	{
		if(!empty($_POST['action'])) { $this->runAdminAction($_POST['action']); }

		elseif(!empty($_GET['delete']) && (!empty($_GET['section']) && $_GET['section'] == 'categories'))
		{
			$this->runAdminAction('delete-category');
		}
		elseif(!empty($_GET['activate']) && (!empty($_GET['section']) && $_GET['section'] == 'categories'))
		{
			$this->runAdminAction('toggle-category');
		}
		elseif(!empty($_GET['sccatlist']) && (!empty($_GET['section']) && $_GET['section'] == 'categories'))
		{
			$this->runAdminAction('process-category-list');
		}
		elseif(!empty($_GET['delete']) && (!empty($_GET['section']) && $_GET['section'] == 'items'))
		{
			$this->runAdminAction('delete-item');
		}
		elseif(!empty($_GET['activate']) && (!empty($_GET['section']) && $_GET['section'] == 'items'))
		{
			$this->runAdminAction('toggle-item');
		}
		elseif(!empty($_GET['scitemlist']) && (!empty($_GET['section']) && $_GET['section'] == 'items'))
		{
			$this->runAdminAction('process-item-list');
		}
	}

	protected function runAdminAction($action)
	{
		switch($action)
		{
			case 'save-category':
				$this->processor->__saveItem('category');
				break;
			case 'delete-category':
				$this->processor->__deleteCategory();
				break;
			case 'toggle-category':
				$this->processor->__toggleCategory();
				break;
			case 'process-category-list':
				$this->processor->__processCategoryList();
				break;
			case 'process-item-list':
				$this->processor->__processItemList();
				break;
			case 'save-item':
				$this->processor->__saveItem('item');
				break;
			case 'delete-item':
				$this->processor->__deleteItem();
				break;
			case 'toggle-item':
				$this->processor->__toggleItem();
				break;
		}
	}

	public function watchFrontendActions()
	{

	}

	protected function runFrontendAction($action)
	{
		switch($action)
		{
			case 'search':
				$this->processor->__saveItem('category');
				break;
			case 'sd':
				$this->processor->__deleteCategory();
				break;
		}
	}
}