<?php namespace ImCatalog\Slider;

class Slider
{
	public  $items  = array();
	public  $markup;
	public 	$jsblock;
	private $msgs   = array();
	private $config;


	public function __construct($config)
	{
		$this->config = &$config;
		$this->readFiles();
		$this->markup = new \stdClass();
		$this->jsblock = $this->buildJsBlock();
		$this->setMarkup('wrapper', '<div class="slider-wrapper '.
			$this->config->animation.'">[[list]][[buttons]]</div>[[jsblock]]');
		$this->setMarkup('infowrapper', '<div class="info-wrapper">[[infotitle]][[infotext]]</div>');
		$this->setMarkup('infotitle', '<h2 class="info-title">[[infotitle]]</h2>');
		$this->setMarkup('infotext', '<div class="info-text">[[infotext]]</div>');
		$this->setMarkup('list', '<ul class="slider-item-list">[[elements]]</ul>');
		$this->setMarkup('element', '<li class="slider-item">[[infowrapper]][[item]]</li>');
		$this->setMarkup('item', '<img alt="" src="[[url]]" />');
		$this->setMarkup('buttons', '<button class="prev"></button><button class="next"></button>');
	}

	private function readFiles()
	{
		global $thisfileid;
		$files = glob(dirname(__DIR__).'/'.$this->config->item_directory.'*.{jpg,jpeg,png,gif}', GLOB_BRACE);
		foreach($files as $file)
		{
			$this->items[] = new Item($file, IM_SITE_URL.'plugins/'.$thisfileid.'/slider/'.$this->config->item_directory);
		}
	}

	public function renderSlider()
	{
		$out = '';
		$elements = '';

		foreach($this->items as $key => $item)
		{
			$elements .= preg_replace('%\[\[( *)item( *)\]\]%', preg_replace(
					'%\[\[( *)url( *)\]\]%', $item->url, $this->markup->item
			), $this->markup->element);
			$title = '';
			if(!empty($this->config->infotext['titles'][$key]))
			{
				$title = preg_replace('%\[\[( *)infotitle( *)\]\]%', $this->config->infotext['titles'][$key],
					$this->markup->infotitle
				);
			}
			$text = '';
			if(!empty($this->config->infotext['texts'][$key]))
			{
				$text = preg_replace('%\[\[( *)infotext( *)\]\]%', $this->config->infotext['texts'][$key],
					$this->markup->infotext
				);
			}
			$infowrapper = '';
			if(!empty($title) || !empty($text))
			{
				$infowrapper = preg_replace('%\[\[( *)infotitle( *)\]\]%', $title, $this->markup->infowrapper);
				$infowrapper = preg_replace('%\[\[( *)infotext( *)\]\]%', $text, $infowrapper);
			}
			$elements = preg_replace('%\[\[( *)infowrapper( *)\]\]%', $infowrapper, $elements);
		}
		$list = preg_replace('%\[\[( *)elements( *)\]\]%', $elements, $this->markup->list);
		$out = preg_replace('%\[\[( *)infotext( *)\]\]%', $list, $this->markup->wrapper);
		$out = preg_replace('%\[\[( *)list( *)\]\]%', $list, $this->markup->wrapper);
		$out = preg_replace('%\[\[( *)buttons( *)\]\]%', $this->markup->buttons, $out);
		$out = preg_replace('%\[\[( *)jsblock( *)\]\]%', $this->jsblock, $out);
		return preg_replace('%\[\[(.*)\]\]%', '', $out);
	}

	public function setMarkup($node, $value)
	{
		if(!in_array($node, array('wrapper', 'list', 'element', 'item', 'buttons',
			'infowrapper', 'infotitle', 'infotext')))
		{
			$this->msgs['error'][] = '<li class="error-msg">Fehler (setMarkup): Nodenbezeichnung unbekannt</li>';
			return false;
		}
		$this->markup->$node = $value;
		return true;
	}

	public function buildJsBlock()
	{
		global $thisfileid;
		$jsblock = "
			<script src=\"".IM_SITE_URL.'plugins/'.$thisfileid."/slider/js/slider.min.js\"></script>
			<script>
			// New instance of slider
			var selector = document.querySelector('.slider-wrapper');
			var slider = new Wallop(selector, {
				buttonPreviousClass: 'prev',
				buttonNextClass: 'next',
				itemClass: 'slider-item',
				currentItemClass: 'slider-item--current',
				showPreviousClass: 'slider-item--showPrevious',
				showNextClass: 'slider-item--showNext',
				hidePreviousClass: 'slider-item--hidePrevious',
				hideNextClass: 'slider-item--hideNext',
				carousel: true
			});
		";

		if($this->config->autoplay == true)
		{
			$jsblock .= "
				var count = slider.allItemsArray.length;
				var start = slider.currentItemIndex;
				var end = count+1;
				var index = (start == 0 ? 1 : start);
				slider.buttonPrevious.addEventListener('click', function () {
					index = slider.currentItemIndex;
				});
				slider.buttonNext.addEventListener('click', function () {
					index = slider.currentItemIndex;
				});
				slider.buttonPrevious.addEventListener('click', function () {
					index = slider.currentItemIndex;
				});
				setInterval(function() {
					slider.goTo(index);
					++index;
					if (index == end) {index=(start+1);}
				},".$this->config->interval.");
			";
		}
		$jsblock .= "</script>";

		return $jsblock;
	}
}



class Item
{
	public $name;
	public $path;
	public $url;

	public function __construct($item, $url)
	{
		$this->name = basename($item);
		$this->path = $item;
		$this->url = $url.$this->name;
	}

}

class Config
{
	public $animation;
	public $autoplay;
	public $interval;
	public $item_directory;
	public $infotext;

	public function __construct()
	{
		$this->animation = 'fade';
		$this->autoplay = false;
		$this->interval = 6000;
		$this->config = 'images/';
	}
}