<?php if(!defined('IN_GS')){ die('you cannot load this page directly.'); }
/**
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * NOTE: DO NOT DELETE OR CHANGE VARIABLES IN THIS FILE!
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 * If you want to change your SimpleCatalog admin templates you should create your own
 * 'custom.admin.php' file in the same directory. To do so, simply copy the admin.php
 * file complete, or only the variable that you want to change or extend to the
 * 'custom.admin.php' file. SimpleCatalog will load it at runtime and read it's
 * content, the entries in this admin.php file will be overwritten by your
 * custom.admin.php changes.
 */

/**
 * Header template
 */
$this->overviewHeader =
<<<EOD
	<div id="manager-header">
		<h3 class="floated">[[plugin_name]]</h3>
		<div class="edit-nav clearfix">
			<a href="load.php?id=[[plugin_id]]&section=categories"[[current_3]]>[[navi_label3]]</a>
			<a href="load.php?id=[[plugin_id]]&section=items"[[current_2]]>[[navi_label2]]</a>
			<a href="load.php?id=[[plugin_id]]"[[current_1]]>[[navi_label1]]</a>
		</div>
	</div>
	<div id="delay"><div id="clamp"><span id="loader"></span></div></div>
	[[messages]]
EOD;

/**
 * Category list wrapper
 */
$this->categoryListForm =
<<<EOD
	<div class="highlight">
		<form method="post" id="itemList" 
			action="load.php?id=[[plugin_id]]&section=categories&action=edit&page=[[page_number]]">
			<table id="im-itemlist-table" class="highlight ui-sortable">
				<thead>
					<tr>
						<th>&nbsp;</th>
						<th>&nbsp;</th>
						<th>[[table_position_label]]</th>
						<th>[[table_name_label]]</th>
						<th>[[table_created_label]]</th>
						<th>[[table_active_label]]</th>
						<th>&nbsp;</th>
					</tr>
				</thead>
				<tbody id="im-itemlist-body">
					[[item_rows]]
				</tbody>
			</table>
			<div class="form-control"><input class="submit" type="submit" name="submit" 
				value="[[create_category]]"></div>
			<div id="im-info-row">
				<div class="paginator-wrapper">[[pagination]]</div>
				<p>[[product_categories]]: <strong>[[count]]</strong><span>items</span></p>
			</div>
		</form>
	</div>
	<script>
		var oldpos = new Array();
		var i=0;
		$(document).ready(function() {
			$('#delay').fadeOut();
			$(document).on({
				ajaxStart: function() { $('#delay').show(); },
				ajaxStop: function() { $('#delay').fadeOut();}
			});
			$('#filterarea select').on('change', function() {
				var num = $('.active').children().attr('id');
				$.getList(num);
				return false;
			});
			$('.switchNumber').click(function(){
				var num = $(this).attr('id');
				$('.active').removeClass('active');
				$(this).parent().addClass('active');
				$.getList(num);
				return false;
			});
			$('#filtervalue').blur(function() {
				var num = $('.active').children().attr('id');
				$.getList(num);
				return false;
			});
			$('#filtervalue').keypress(function (e) {
				if(e.which == 13) {
					var num = $('.active').children().attr('id');
					$.getList(num);
					return false;
				}
			});
			$('.im-pos').dblclick(function (e) {
				e.stopPropagation();
				var currentPosField = $(this).children('.position');
				var currentEle = $(this).children('.index');
				var value = currentEle.html();
				updateVal(currentEle, value, value.length, currentPosField);
			});
			$.indexPos = function() {
				$('#im-itemlist-table tbody tr').each(function(i,tr) {
					$(tr).find('.position').each(function(k, elem) {
						oldpos[i] = $(elem).val();
						i++;
					});
				});
			}
			$('#im-itemlist-table tbody tr').each(function(i,tr) {
				$.indexPos();
			});
			$('#im-itemlist-table').sortable({
				items:"tr.sortable", handle:'td',
				update:function(e,ui) {
					$('#im-itemlist-table tbody tr').each(function(i,tr) {
						$(tr).find('.position').each(function(k,elem) {
							if($(elem).val()  != oldpos[i]){
								$(elem).val(oldpos[i]);
								$(tr).find('.index').text(oldpos[i]);
								$(tr).find('.index').stop().css('color', '#000000').animate({ color: '#777777'}, 1500);
							}
						});
					});

					var num = $('.active').children().attr('id');
					$.getList(num);
					$.indexPos();
				}
			});

			$.getList = function(num) {
				var ftr = $('#filterby').val();
				var opt = $('#option').val();
				var ordf = $('#filterbyfield').val();
				var flr = $('#filter').val();
				var flrv = $('#filtervalue').val();

				var form = $('#itemList');
				jsonObj = [];

				form.find('input.position').each(function() {
					var id = $(this).attr('name');
					var position = $(this).val();
					item = {}
					item ['id'] = id;
					item ['position'] = position;
					jsonObj.push(item);
				});
				$.post("load.php?id=[[plugin_id]]&section=categories&sccatlist="+num+"&page=[[page_number]]&filterby="+ftr+"&option="+opt+"&filterbyfield="+ordf+"&filter="+flr+"&filtervalue="+flrv,
					{ positions: jsonObj },
					function(data, status){
						//console.log(data);
						if(status = 'success' && data.rows) {
							$('#im-itemlist-body').html(data.rows);
							if(data.pagination) $('.paginator-wrapper').html(data.pagination);
						}
					}, "json"
				);
			}
		});
		function updateVal(currentEle, value, len, currentPosField) {
			$(document).off('click');
			$(currentEle).html("<input class='dyn-pos' onkeypress='return event.keyCode != 13;' type='number' value='" + value + "'>");
			var el = $('.dyn-pos');
			var value = el.val();
			var num = $('.active').children().attr('id');
			if(len != 0) {
				el.selectionStart = len;
				el.selectionEnd = len;
				setTimeout(function() {
					el.focus();
				}, 1);
			}
			el.keyup(function (event) {
				if (event.keyCode == 13) {
					$(currentEle).html(el.val().trim());
					currentPosField.val(el.val().trim());
					$.getList(num);
				}
			});
			$(document).click(function () {
				$(currentEle).html(currentPosField.val());
				$(currentEle).stop().css('color', '#CF3805').animate({ color: '#777777'}, 1500);
			});
		}
		$(document).ajaxComplete(function(){
			$('.im-pos').dblclick(function (e) {
				e.stopPropagation();
				var currentPosField = $(this).children('.position');
				var currentEle = $(this).children('.index');
				var value = currentPosField.val();
				updateVal(currentEle, value, value.length, currentPosField);
			});
			$('#im-itemlist-table tbody tr').each(function(i,tr) {
				$(tr).find('.position').each(function(k, elem) {
					oldpos[i] = $(elem).val();
					i++;
				});
			});
		});
	</script>
EOD;

/**
 * Category row template
 */
$this->categoryRow =
<<<EOD
	<tr class="sortable">
		<td class="im-drag">
			<i class="fa fa-hand-o-up" aria-hidden="true"></i>
		</td>
		<td>
			<span class="image"><a href="load.php?id=[[plugin_id]]&section=categories&action=edit&edit=[[item_id]]&page=[[page_number]]" 
				title="Edit item: [[item_title]]"><img src="[[cover_image]]"></a></span>
		</td>
		<td class="im-pos">
			<span class="index">[[pos]]</span><input type="hidden" class="position" name="[[item_id]]" value="[[pos]]">
		</td>
		<td>
			<a href="load.php?id=[[plugin_id]]&section=categories&action=edit&edit=[[item_id]]&page=[[page_number]]" 
				title="Edit item: [[item_title]]">[[item_title]]</a>
		</td>
		<td>
			[[created]]
		</td>
		<td>
			<a href="load.php?id=[[plugin_id]]&activate=[[item_id]]&section=categories&page=[[page_number]]" 
				class="switch_active" title="activate/deactivate item"><i class="fa [[active]]" aria-hidden="true"></i></a>
		</td>
		<td class="im-del">
			<a onclick="return confirm('Are you sure you want to delete item?');" 
				href="load.php?id=[[plugin_id]]&delete=[[item_id]]&section=categories&page=[[page_number]]" 
					title="Delete item"><i class="fa fa-times" aria-hidden="true"></i></a>
		</td>
	</tr>
EOD;


$this->categoryEdotorWrapper =
<<<EOD
	<div class="manager-wrapper">
		<form class="largeform" 
			action="load.php?id=[[plugin_id]]&section=categories&action=edit[[url_id]]&page=[[page_number]]" 
				method="post" accept-charset="utf-8">
			<div>
				<div id="cat-details">
					<h3 class="menuglava">[[category_header]]</h3>
					<div class="fieldarea">
						<label for="catid" class="im-left">[[cat_id_label]]</label>
						
						<p id="catid" class="im-cat-info">[[cat_id]]</p>
					</div>
	
					<div class="fieldarea">
						<label for="catname">[[cat_name_label]]</label>
						<p><input id="catname" class="text" name="name" type="text" value="[[cat_name_value]]"></p>
					</div>
	
					<div class="fieldarea">
						<label for="catposition">[[cat_pos_label]]</label>
						<p><input id="catposition" class="number-fields-left number" name="itempos" 
							type="number" value="[[cat_pos_value]]"></p>
					</div>
					
					[[fields]]
	
					<div class="fieldarea">
						<label for="catcreated">[[cat_created_label]]</label>
						<p class="im-cat-info">[[cat_created_value]]</p>
					</div>
	
					<div class="fieldarea">
						<label for="catmodified">[[cat_modified_label]]</label>
						<p class="im-cat-info">[[cat_modified_value]]</p>
					</div>
	
					<input type="hidden" value="[[categoryid]]" name="categoryid">
					<input type="hidden" value="[[timestamp]]" name="timestamp">
					<input type="hidden" value="save-category" name="action">
					<p class="form-control"><span><input class="submit" type="submit" name="category_save" 
						value="[[cat_save_button]]"></span></p>
				</div>
			</div>
		</form>
	</div>
EOD;

$this->itemListForm =
<<<EOD
	<div class="highlight">
		<form method="post" id="itemList" 
			action="load.php?id=[[plugin_id]]&section=items&action=edit&page=[[page_number]]">
			<div class="manager-wrapper">
				<fieldset class="cat-selector">
					<label for="categorySelector">[[select_category_label]]</label>
					<select name="categoryid" id="cat">
						[[options]]
					</select>
				</fieldset>
			</div>
			<table id="im-itemlist-table" class="highlight ui-sortable">
				<thead>
					<tr>
						<th>&nbsp;</th>
						<th>&nbsp;</th>
						<th>[[table_position_label]]</th>
						<th>[[table_name_label]]</th>
						<th>[[table_created_label]]</th>
						<th>[[table_active_label]]</th>
						<th>&nbsp;</th>
					</tr>
				</thead>
				<tbody id="im-itemlist-body">
					[[item_rows]]
				</tbody>
			</table>
			<div class="form-control"><input class="submit" type="submit" name="submit" 
				value="[[create_item]]"></div>
			<div id="im-info-row">
				<div class="paginator-wrapper">[[pagination]]</div>
				<p>[[product_categories]]: <strong>[[count]]</strong><span>items</span></p>
			</div>
		</form>
	</div>
	<script>
		var oldpos = new Array();
		var i=0;
		$(document).ready(function() {
			$('#delay').fadeOut();
			$(document).on({
				ajaxStart: function() { $('#delay').show(); },
				ajaxStop: function() { $('#delay').fadeOut();}
			});
			$('#cat').on('change', function() {
				$.getList(0);
			});
			$('#filterarea select').on('change', function() {
				var num = $('.active').children().attr('id');
				$.getList(num);
				return false;
			});
			$('.switchNumber').click(function(){
				var num = $(this).attr('id');
				$('.active').removeClass('active');
				$(this).parent().addClass('active');
				$.getList(num);
				return false;
			});
			$('#filtervalue').blur(function() {
				var num = $('.active').children().attr('id');
				$.getList(num);
				return false;
			});
			$('#filtervalue').keypress(function (e) {
				if(e.which == 13) {
					var num = $('.active').children().attr('id');
					$.getList(num);
					return false;
				}
			});
			$('.im-pos').dblclick(function (e) {
				e.stopPropagation();
				var currentPosField = $(this).children('.position');
				var currentEle = $(this).children('.index');
				var value = currentEle.html();
				updateVal(currentEle, value, value.length, currentPosField);
			});
			$.indexPos = function() {
				$('#im-itemlist-table tbody tr').each(function(i,tr) {
					$(tr).find('.position').each(function(k, elem) {
						oldpos[i] = $(elem).val();
						i++;
					});
				});
			}
			$('#im-itemlist-table tbody tr').each(function(i,tr) {
				$.indexPos();
			});
			$('#im-itemlist-table').sortable({
				items:"tr.sortable", handle:'td',
				update:function(e,ui) {
					$('#im-itemlist-table tbody tr').each(function(i,tr) {
						$(tr).find('.position').each(function(k,elem) {
							if($(elem).val()  != oldpos[i]){
								$(elem).val(oldpos[i]);
								$(tr).find('.index').text(oldpos[i]);
								$(tr).find('.index').stop().css('color', '#000000').animate({ color: '#777777'}, 1500);
							}
						});
					});

					var num = $('.active').children().attr('id');
					$.getList(num);
					$.indexPos();
				}
			});

			$.getList = function(num) {
				var catid = $('#cat').val();
				var ftr = $('#filterby').val();
				var opt = $('#option').val();
				var ordf = $('#filterbyfield').val();
				var flr = $('#filter').val();
				var flrv = $('#filtervalue').val();

				var form = $('#itemList');
				jsonObj = [];

				form.find('input.position').each(function() {
					var id = $(this).attr('name');
					var position = $(this).val();
					item = {}
					item ['id'] = id;
					item ['position'] = position;
					jsonObj.push(item);
				});
				$.post("load.php?id=[[plugin_id]]&section=items&scitemlist="+catid+"&page=[[page_number]]&filterby="+ftr+"&option="+opt+"&filterbyfield="+ordf+"&filter="+flr+"&filtervalue="+flrv,
					{ positions: jsonObj },
					function(data, status){
						//console.log(data.rows);
						if(status = 'success' && data.rows) {
							$('#im-itemlist-body').html(data.rows);
							if(data.pagination) $('.paginator-wrapper').html(data.pagination);
						} else {
							$('#im-itemlist-body').html('');
							$('.paginator-wrapper').html('');
						}
					}, "json"
				);
			}
		});
		function updateVal(currentEle, value, len, currentPosField) {
			$(document).off('click');
			$(currentEle).html("<input class='dyn-pos' onkeypress='return event.keyCode != 13;' type='number' value='" + value + "'>");
			var el = $('.dyn-pos');
			var value = el.val();
			var num = $('.active').children().attr('id');
			if(len != 0) {
				el.selectionStart = len;
				el.selectionEnd = len;
				setTimeout(function() {
					el.focus();
				}, 1);
			}
			el.keyup(function (event) {
				if (event.keyCode == 13) {
					$(currentEle).html(el.val().trim());
					currentPosField.val(el.val().trim());
					$.getList(num);
				}
			});
			$(document).click(function () {
				$(currentEle).html(currentPosField.val());
				$(currentEle).stop().css('color', '#CF3805').animate({ color: '#777777'}, 1500);
			});
		}
		$(document).ajaxComplete(function(){
			$('.im-pos').dblclick(function (e) {
				e.stopPropagation();
				var currentPosField = $(this).children('.position');
				var currentEle = $(this).children('.index');
				var value = currentPosField.val();
				updateVal(currentEle, value, value.length, currentPosField);
			});
			$('#im-itemlist-table tbody tr').each(function(i,tr) {
				$(tr).find('.position').each(function(k, elem) {
					oldpos[i] = $(elem).val();
					i++;
				});
			});
		});
	</script>
EOD;

/**
 * Options template
 */
$this->selectOption =
<<<EOD
	<option value="[[value]]"[[selected]]>[[label]]</option>
EOD;


/**
 * Category row template
 */
$this->itemRow =
<<<EOD
	<tr class="sortable">
		<td class="im-drag">
			<i class="fa fa-hand-o-up" aria-hidden="true"></i>
		</td>
		<td>
			<span class="image"><a href="load.php?id=[[plugin_id]]&section=items&action=edit&edit=[[item_id]]&page=[[page_number]]" 
				title="Edit item: [[item_title]]"><img src="[[cover_image]]"></a></span>
		</td>
		<td class="im-pos">
			<span class="index">[[pos]]</span><input type="hidden" class="position" name="[[item_id]]" value="[[pos]]">
		</td>
		<td>
			<a href="load.php?id=[[plugin_id]]&section=items&action=edit&edit=[[item_id]]&page=[[page_number]]" 
				title="Edit item: [[item_title]]">[[item_title]]</a>
		</td>
		<td>
			[[created]]
		</td>
		<td>
			<a href="load.php?id=[[plugin_id]]&activate=[[item_id]]&section=items&page=[[page_number]]" 
				class="switch_active" title="activate/deactivate item"><i class="fa [[active]]" aria-hidden="true"></i></a>
		</td>
		<td class="im-del">
			<a onclick="return confirm('Are you sure you want to delete item?');" 
				href="load.php?id=[[plugin_id]]&delete=[[item_id]]&section=items&page=[[page_number]]" 
					title="Delete item"><i class="fa fa-times" aria-hidden="true"></i></a>
		</td>
	</tr>
EOD;


$this->itemEdotorWrapper =
<<<EOD
	<div class="manager-wrapper">
		<form class="largeform" 
			action="load.php?id=[[plugin_id]]&section=items&action=edit[[url_id]]&page=[[page_number]]" 
				method="post" accept-charset="utf-8">
			<div>
				<div id="cat-details">
					<h3 class="menuglava">[[item_header]]</h3>
					<div class="fieldarea">
						<label for="catid" class="im-left">[[item_id_label]]</label>
						
						<p id="catid" class="im-cat-info">[[item_id]]</p>
					</div>
	
					<div class="fieldarea">
						<label for="catname">[[item_name_label]]</label>
						<p><input id="catname" class="text" name="name" type="text" value="[[item_name_value]]"></p>
					</div>
	
					<div class="fieldarea">
						<label for="catposition">[[item_pos_label]]</label>
						<p><input id="catposition" class="number-fields-left number" name="itempos" 
							type="number" value="[[item_pos_value]]"></p>
					</div>
					
					[[fields]]
	
					<div class="fieldarea">
						<label for="itemcreated">[[item_created_label]]</label>
						<p class="im-cat-info">[[item_created_value]]</p>
					</div>
	
					<div class="fieldarea">
						<label for="itemmodified">[[item_modified_label]]</label>
						<p class="im-cat-info">[[item_modified_value]]</p>
					</div>
	
					<input type="hidden" value="[[categoryid]]" name="categoryid">
					<input type="hidden" value="[[timestamp]]" name="timestamp">
					<input type="hidden" value="save-item" name="action">
					<p class="form-control"><span><input class="submit" type="submit" name="item_save" 
						value="[[item_save_button]]"></span></p>
				</div>
			</div>
		</form>
	</div>
EOD;

$this->dashboardWrapper =
<<<EOD
	<div class="manager-wrapper dashboard">
		<ul id="info-block">
			<li>[[items_total]] <span>[[it_total_number]]</span></li>
			<li>[[categories_total]] <span>[[ct_total_number]]</span></li>
		</ul>
		[[slider]]
		<h4>[[recent_items]]</h4>
		<div class="recent-items-wrapper">
			[[recent-items]]
		</div>
		<div id="dashb-footer">
			<ul class="dashb-footer-navi">
				<li>Created by: [[creator]]</li>
				<li class="sep">•</li>
				<li>eMail: [[creator_mail]]</li>
				<li class="sep">•</li>
				<li>Phone: [[creator_phone]]</li>
				<li class="sep">•</li>
				<li>More infos: [[infos]]</li>
			</ul>
		</div>
	</div>
EOD;

$this->recentItemRow =
<<<EOD
	<div class="data-element">
		<div class="data">
			<a href="[[url]]">[[image]]</a>
			<p class="data-title">[[title]]</p>
		</div>
	</div>
EOD;

$this->imageElement =
<<<EOD
	<img alt="[[alt]]" src="[[src]]">
EOD;
