<?php if(!defined('IN_GS')){ die('you cannot load this page directly.'); }
/**
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * NOTE: DO NOT DELETE OR CHANGE VARIABLES IN THIS FILE!
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 * If you want to change your SimpleCatalog frontend templates you should create your own
 * 'custom.frontend.php' file in the same directory. To do so, simply copy the frontend.php
 * file complete, or only the variables that you want to change/extend to the
 * 'custom.frontend.php' file. SimpleCatalog will load it at runtime and read it's content,
 * the entries in this frontend.php file will be overwritten by your custom.frontend.php
 * changes.
 */


/**
 * Category list templates
 */
$this->categoryListWrapper =
<<<EOD
	<div class="sc-cl-wrapper">
		[[header]]
		[[breadcrumbs]]
		[[content]]
		[[pagination]]
		[[footer]]
	</div>
EOD;


$this->categoryListHeader =
<<<EOD
	<div class="sc-cl-header">
		<h1>[[category_list_title]]</h1>
		[[search_form]]
	</div>
EOD;


$this->categoryRow =
<<<EOD
	<section class="sc-element-wrapper">
		<figure>
			<a href="[[href]]"><img src="[[image]]" alt="[[image_title]]"></a>
		</figure>
		<header><h3>[[name]]</h3></header>
		<div class="sc-element-infos">
			[[description]]
			<div class="sc-element-navi">
				[[category_info]]
			</div>
		</div>
	</section>
EOD;


$this->categoryInfo =
<<<EOD
	<div class="info-link-wrapper">
		<a href="[[href]]">[[info_link]]</a>
	</div>
EOD;


/**
 * Item list templates
 */
$this->itemListWrapper =
<<<EOD
	<div class="sc-il-wrapper">
		[[header]]
		[[breadcrumbs]]
		[[content]]
		[[pagination]]
		[[footer]]
	</div>
EOD;


$this->itemListHeader =
<<<EOD
	<div class="sc-il-header">
		<h1>[[item_list_title]]</h1>
		[[search_form]]
	</div>
EOD;


$this->itemRow =
<<<EOD
	<section class="sc-element-wrapper">
		[[figure]]
		<header><h3>[[name]]</h3></header>
		<div class="sc-element-infos">
			[[summary]]
			<div class="sc-element-navi">
				[[item_info]]
				[[tags]]
			</div>
		</div>
	</section>
EOD;


$this->itemInfo =
<<<EOD
	<div class="info-link-wrapper">
		<a href="[[href]]">[[info_link]]</a>
	</div>
EOD;


$this->tagsWrapper =
<<<EOD
	<ul class="tags">
		[[tags]]
	</ul>
EOD;


$this->tag =
<<<EOD
	 <li><a href="[[href]]" class="tag">[[tag_label]]</a></li>
EOD;


/**
 * Item details
 */
$this->itemDetailsWrapper =
<<<EOD
	<div class="sc-id-wrapper">
		[[header]]
		[[breadcrumbs]]
		[[content]]
		[[footer]]
	</div>
EOD;


$this->itemDetailsHeader =
<<<EOD
	<div class="sc-id-header">
		<h1>[[item_details_title]]</h1>
		[[search_form]]
	</div>
EOD;


$this->itemDetailsContent =
<<<EOT
	<div class="sc-element-wrapper">
		<figure>
			<img src="[[image_s_0]]" alt="[[image_title_s_0]]">
		</figure>
		<div class="sc-element-details">
			[[description]]
		</div>
	</div>
EOT;


/**
 * Search-results area
 */
$this->searchResultWrapper =
<<<EOD
	<div class="sc-sr-wrapper">
		[[header]]
		[[breadcrumbs]]
		[[search_info]]
		[[content]]
		[[footer]]
	</div>
EOD;


$this->searchResultHeader =
<<<EOD
	<div class="sc-sr-header">
		<h1>[[search_result_title]]</h1>
		[[search_form]]
	</div>
EOD;


$this->searchResultRow =
<<<EOT
	[[category_title]]
	<section class="sc-result-wrapper">
		[[figure]]
		<header><h5><a href="[[href]]">[[name]]</a></h5></header>
		<div class="sc-element-infos">
			[[summary]]
		</div>
	</section>
EOT;


$this->searchInfo =
<<<EOT
	<div id="result-info">[[info]]</div>
EOT;



/**
 * Global templates
 */
$this->serchForm =
<<<EOD
	<div class="sc-search-wrapper">
		<form class="sc-search-form" action="[[search_action]]" method="get">
			<input type="text" name="search" placeholder="[[placeholder]]">
		</form>
	</div>
EOD;


$this->breadCrumbs =
<<<EOD
	<div id="breadcrumbs">
		<ul class="crumbs">
			[[crumbs]]
		</ul>
	</div>
EOD;


$this->crumb =
<<<EOD
	<li[[class]]><a href="[[href]]">[[crumb_label]] &rang;</a></li>
EOD;


$this->itemFigure =
<<<EOD
	<figure>
		<a href="[[href]]"><img src="[[image]]" alt="[[image_title]]"></a>
	</figure>
EOD;

$this->h2Header =
<<<EOD
	<h2>[[title]]</h2>
EOD;

$this->h3Header =
<<<EOD
	<h3>[[title]]</h3>
EOD;

?>